## setting the working directory
setwd("C:/.../R-Codes_EMS_2013")

# seting the memory size
memory.limit(size=2^12-1)


# loading packages
library(tseries)
library(xtable)
library(vars)
library(moments)
library(reshape)
library(RColorBrewer)
library(grDevices)


# uploading functions
source("Functions/adf.boot.r")
source("Functions/dummy.r")
source("Functions/startest.r")
source("Functions/star.r")

# uploading data from the NOAA website
ensodat <- read.table("http://www.cpc.ncep.noaa.gov/data/indices/ersst3b.nino.mth.ascii",header=TRUE)


SSTA <- as.matrix(ensodat[,10])
enso.f <- as.matrix(SSTA)


enso.ssn <- matrix(,(nrow(enso.f)-4),1)    # 5 month average (replace 4 by 2 for 3 month average)
for(i in 1:nrow(enso.ssn)){
  enso.ssn[i,] <- mean(enso.f[i:(i+4),])   # 5 month running averages
}


ts.enso.ssn  <- ts(enso.ssn,start=c(1950,5),end=c(2012,3),frequency=12)
mat.enso.ssn <- tapply(ts.enso.ssn,list(year=floor(time(ts.enso.ssn)),month=cycle(ts.enso.ssn)),c)[c(-1,-63),]



elnino <-as.matrix(mat.enso.ssn[mat.enso.ssn[,1] >  0.5,])   # paper Ubilava: 0.45 and -0.45
lanina <-as.matrix(mat.enso.ssn[mat.enso.ssn[,1] < -0.5,])

elnino.m <- colMeans(elnino)
lanina.m <- colMeans(lanina)


elnino.ssn <- enso.ssn
elnino.ssn[which(elnino.ssn <  0.5),] <- NA    # make changes according to moving average
ts.elnino.ssn <- ts(elnino.ssn,start=c(1950,5),end=c(2012,3),frequency=12)

lanina.ssn <- enso.ssn
lanina.ssn[which(lanina.ssn > -0.5),] <- NA
ts.lanina.ssn <- ts(lanina.ssn,start=c(1950,5),end=c(2012,3),frequency=12)


png(filename="Figures/ENSO_Descriptive.png",height=2400,width=2400,bg="white",res=300)
par(mfrow=c(2,1),mar=c(6,4,2,1),oma=c(0,0,0,0))
ts.plot(cbind(enso.ssn,elnino.ssn,lanina.ssn),lwd=2,col=c("darkgray","darkred","darkblue"),main="(a) Observed Running 3-month Mean of Nino3.4 SST Anomaly",ylab="SST Anomaly",xlab="Year",ylim=c(-3.0,3.0))
legend("bottomright",legend=c("El Nino","Neutral","La Nina"),lwd=c(2,2,2),col=c("darkred","darkgray","darkblue"),bty="n",cex=0.9)
ts.plot(cbind(elnino.m,lanina.m),lwd=2,col=c("darkred","darkblue"),main="(b) Observed ENSO Dynamics after El Nino and La Nina Events",ylab="SST Anomaly",xlab="Horizon")
abline(h=0,col="darkgray",lty=2)
legend("bottomright",legend=c("El Nino","La Nina"),lwd=c(2,2),col=c("darkred","darkblue"),bty="n",cex=0.9)
dev.off()


png(filename="Figures/ENSO_Droughts.png",height=1200,width=2400,bg="white",res=300)
plot(ts.enso.ssn,type="l",lwd=2,col=c("darkgray"),main="Three-month Running Mean of Nino3.4 SST Anomaly",ylab="SST Anomaly",xlab="Year",ylim=c(-3.0,3.0))
# legend("topleft",legend=c("El Nino","Neutral","La Nina"),lwd=c(2,2,2),col=c("darkred","darkgray","darkblue"),bty="n",cex=0.9)
par(new=T)
plot(ts.elnino.ssn,type="l",lwd=2,col=c("darkred"),main="",ylab="",xlab="",ylim=c(-3.0,3.0))
par(new=T)
plot(ts.lanina.ssn,type="l",lwd=2,col=c("darkblue"),main="",ylab="",xlab="",ylim=c(-3.0,3.0))
abline(v=c(1956.5,1988.5,2012.5),lwd=rep(3,3),col=rep("#cc663366",3))
dev.off()



# uploading forecasts

#hor <- 36
nit <- yrmax


enso.act.l.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
for(j in 1:12){
enso.act.l.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_l_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,1]
}
}


enso.for.l.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
for(j in 1:12){
enso.for.l.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_l_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,2]
}
}

enso.for.l.prb <- array(,dim=c(5,(hor+1),12*nit))
for(i in 1:nit){
for(j in 1:12){
enso.for.l.prb[,,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/prob_l_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))
}
}

enso.for.n.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
for(j in 1:12){
enso.for.n.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_n_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,2]
}
}

enso.for.n.prb <- array(,dim=c(5,(hor+1),12*nit))
for(i in 1:nit){
for(j in 1:12){
enso.for.n.prb[,,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/prob_n_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))
}
}






enso.act.ssn.l.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
  for(j in 1:12){
    enso.act.ssn.l.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_l_ssn_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,1]
  }
}


enso.for.ssn.l.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
  for(j in 1:12){
    enso.for.ssn.l.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_l_ssn_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,2]
  }
}

enso.for.ssn.l.prb <- array(,dim=c(5,(hor+1),12*nit))
for(i in 1:nit){
  for(j in 1:12){
    enso.for.ssn.l.prb[,,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/prob_l_ssn_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))
  }
}

enso.for.ssn.n.mat <- matrix(,(hor+1),12*nit)
for(i in 1:nit){
  for(j in 1:12){
    enso.for.ssn.n.mat[,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/enso_n_ssn_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[,2]
  }
}

enso.for.ssn.n.prb <- array(,dim=c(5,(hor+1),12*nit))
for(i in 1:nit){
  for(j in 1:12){
    enso.for.ssn.n.prb[,,((i-1)*12+j)] <- as.matrix(read.table(file=paste("Forecasts/prob_n_ssn_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))
  }
}


### correlation maps

ssn.3 <- c("JFM","FMA","MAM","AMJ","MJJ","JJA","JAS","ASO","SON","OND","NDJ","DJF")


#persistence
cor.mat <- matrix(,12,12)
for(k in 1:12){  
  mon.vec <- matrix(,nit,1)  
  for(j in 1:12){
    for(i in 1:nit){
      mon.vec[i,] <- (i-1)*12+(j-1) 
    }
    cor.mat[k,j] <- cor(enso.act.l.mat[1,mon.vec],enso.act.ssn.l.mat[(k+2),mon.vec])
  }
  
}

max.cor <- max(cor.mat)
min.cor <- min(cor.mat)

rb.1 <- (1-max.cor)/2
rb.2 <- (1-min.cor)/2



#linear
cor.mat.l <- matrix(,12,12)
for(k in 1:12){  
mon.vec <- matrix(,nit,1)
for(j in 1:12){
for(i in 1:nit){
mon.vec[i,] <- (i-1)*12+(j-1) 
}
cor.mat.l[k,j] <- cor(enso.act.ssn.l.mat[(k+2),mon.vec],enso.for.ssn.l.mat[(k+2),mon.vec])
}
}

max.cor.l <- max(cor.mat.l)
min.cor.l <- min(cor.mat.l)

rb.l.1 <- (1-max.cor.l)/2
rb.l.2 <- (1-min.cor.l)/2




#nonlinear
cor.mat.n <- matrix(,12,12)
for(k in 1:12){  
  mon.vec <- matrix(,nit,1)
  for(j in 1:12){
    for(i in 1:nit){
      mon.vec[i,] <- (i-1)*12+(j-1) 
    }
    cor.mat.n[k,j] <- cor(enso.act.ssn.l.mat[(k+2),mon.vec],enso.for.ssn.n.mat[(k+2),mon.vec])
  }
}

max.cor.n <- max(cor.mat.n)
min.cor.n <- min(cor.mat.n)

rb.n.1 <- (1-max.cor.n)/2
rb.n.2 <- (1-min.cor.n)/2



png(filename="Figures/Correlations.png",height=1600,width=4400,bg="white",res=300)
par(mfrow=c(1,3),mar=c(4,4,2,1),oma=c(0,0,0,0),cex=1.5)
image(c(1:12),c(1:12),cor.mat,col=rainbow(144,start=rb.1,end=rb.2,alpha=1.0)[144:1],axes=FALSE,xlab="Horizon",ylab="Season",main="Persistence",oldstyle=T)
axis(1,at=c(1:12),lty=0,cex.axis=0.9)
axis(2,at=c(1:12),lty=0,labels=ssn.3,las=2,cex.axis=0.8)
contour(c(1:12),c(1:12),cor.mat,levels=seq(.5,.9, by=.2),add=TRUE,col="black",lwd=2,labcex=1.5,method="edge")

image(c(1:12),c(1:12),cor.mat.l,col=rainbow(144,start=rb.l.1,end=rb.l.2,alpha=1.0)[144:1],axes=FALSE,xlab="Horizon",ylab="Season",main="AR",oldstyle=T)
axis(1,at=c(1:12),lty=0,cex.axis=0.9)
axis(2,at=c(1:12),lty=0,labels=ssn.3,las=2,cex.axis=0.8)
contour(c(1:12),c(1:12),cor.mat.l,levels=seq(.5,.9, by=.2),add=TRUE,col="black",lwd=2,labcex=1.5,method="edge")

image(c(1:12),c(1:12),cor.mat.n,col=rainbow(144,start=rb.n.1,end=rb.n.2,alpha=1.0)[144:1],axes=FALSE,xlab="Horizon",ylab="Season",main="STAR",oldstyle=T)
axis(1,at=c(1:12),lty=0,cex.axis=0.9)
axis(2,at=c(1:12),lty=0,labels=ssn.3,las=2,cex.axis=0.8)
contour(c(1:12),c(1:12),cor.mat.n,levels=seq(.5,.9, by=.2),add=TRUE,col="black",lwd=2,labcex=1.5,method="edge")
dev.off()








ts.ssn.act  <- ts(((enso.act.ssn.l.mat[1,])),frequency=12)
mat.ssn.act <- tapply(ts.ssn.act,list(year=floor(time(ts.ssn.act)),month=cycle(ts.ssn.act)),c)[-63,]

ssn.abb <- c("NDJ","DJF","JFM","FMA","MAM","AMJ","MJJ","JJA","JAS","ASO","SON","OND")

sst.lab <- c("SST < -0.90","-0.90 < SST < -0.45","-0.45 < SST < 0.45","0.45 < SST < 0.90","0.90 < SST")


event.date <- 6*12+5  #  (16*12+10 is oct 2008 plus 2 maanden, start dus dec. 2008)
                        #  6*12 + 5 is as in U-H paper

bp.l <- enso.for.ssn.l.prb[,,event.date]
bp.n <- enso.for.ssn.n.prb[,,event.date]

nc <- 5
plot.col.us <- brewer.pal(nc,"RdYlBu")[nc:1]

ensomat <- as.matrix(ensodat)

datnames <- matrix(,(hor+1),1)
for(j in 1:(hor+1)){
month.j <- ensomat[(492+event.date),2]+j
year.j  <- ensomat[(492+event.date),1]
if(month.j > 36){
mnth <- ssn.abb[month.j-36]
year <- year.j+3
}else if(month.j > 24){
mnth <- ssn.abb[month.j-24]
year <- year.j+2
}else if(month.j > 12){
mnth <- ssn.abb[month.j-12]
year <- year.j+1
}else{
mnth <- ssn.abb[month.j]
year <- year.j
}

datnames[j,] <- paste(mnth,year)
}

colnames(bp.l) <- c(datnames)
colnames(bp.n) <- c(datnames)

bp.a <- matrix(0,5,18)
for(i in 1:18){
    if(enso.act.ssn.l.mat[1,(event.date+2+i)] < -0.9){
      bp.a[1,i] <- 1
    }else if(enso.act.ssn.l.mat[1,(event.date+2+i)] < -0.45){
      bp.a[2,i] <- 1
    }else if(enso.act.ssn.l.mat[1,(event.date+2+i)] <  0.45){
      bp.a[3,i] <- 1
    }else if(enso.act.ssn.l.mat[1,(event.date+2+i)] <  0.9){
      bp.a[4,i] <- 1
    }else{
      bp.a[5,i] <- 1
    }
}


png(file="Figures/ENSO_PROB.png",height=2400,width=2400,bg="white",res=300)
layout(matrix(c(1,2,3),3,1),heights=c(11,11,5))
#par(mfrow=c(3,1),cex=1.0)
barplot(bp.l[,4:(4+18-1)],ylab="",col=c(plot.col.us),space=0.1,cex.axis=1.8,cex.names=1.8,las=1)
title(main="AR",font.main=2,cex.main=2)
barplot(bp.n[,4:(4+18-1)],ylab="",col=c(plot.col.us),space=0.1,cex.axis=1.8,cex.names=1.8,las=1)
title(main="STAR",font.main=2,cex.main=2)
barplot(bp.a,ylab="",col=c(plot.col.us),space=0.1,cex.axis=1.8,cex.names=1.8,las=1,axes=F)
title(main="Actual Realization",font.main=2,cex.main=2)
#plot(1,type="n",axes=F,xlab="",ylab="",xlim=c(0,1),ylim=c(0,1))
par(xpd=T)
legend( 0,-0.3,legend=sst.lab[1:2],fill=c(plot.col.us[1:2]),bty="n",horiz=F,cex=1.5) 
legend( 7,-0.7,legend=sst.lab[3],fill=c(plot.col.us[3]),bty="n",horiz=F,cex=1.5)
legend(14,-0.3,legend=sst.lab[4:5],fill=c(plot.col.us[4:5]),bty="n",horiz=F,cex=1.5)
dev.off()




#C-W test
t.h.l <- matrix(,hor,3)
rmsfe <- matrix(,hor,3)

for(k in 1:hor){

f.h.a <- enso.act.l.mat[(k+1),]-enso.act.l.mat[(1),]
f.h.l <- enso.act.l.mat[(k+1),]-enso.for.l.mat[(k+1),]
f.h.n <- enso.act.l.mat[(k+1),]-enso.for.n.mat[(k+1),]

f.h.al <- enso.act.l.mat[(1),]  -enso.for.l.mat[(k+1),]
f.h.an <- enso.act.l.mat[(1),]  -enso.for.n.mat[(k+1),]
f.h.ln <- enso.for.l.mat[(k+1),]-enso.for.n.mat[(k+1),]

rmsfe[k,] <- c(sqrt(mean(f.h.a^2)),sqrt(mean(f.h.l^2)),sqrt(mean(f.h.n^2)))

f.h.1 <- as.matrix(f.h.a^2 - (f.h.l^2 - f.h.al^2))
f.h.2 <- as.matrix(f.h.a^2 - (f.h.n^2 - f.h.an^2))
f.h.3 <- as.matrix(f.h.l^2 - (f.h.n^2 - f.h.ln^2))

model.1 <- lm(f.h.1~1)
model.2 <- lm(f.h.2~1)
model.3 <- lm(f.h.3~1)

b.h.1 <- coef(summary(model.1))[,1]
b.h.2 <- coef(summary(model.2))[,1]
b.h.3 <- coef(summary(model.3))[,1]

s.h.1 <- sqrt(vcovHAC(model.1))
s.h.2 <- sqrt(vcovHAC(model.2))
s.h.3 <- sqrt(vcovHAC(model.3))

t.h.l[k,1] <- b.h.1/s.h.1
t.h.l[k,2] <- b.h.2/s.h.2
t.h.l[k,3] <- b.h.3/s.h.3
}


t.h.l.ssn <- matrix(,hor,3)
rmsfe.ssn <- matrix(,hor,3)

for(k in 1:hor){
  
  f.h.a <- enso.act.ssn.l.mat[(k+1),]-enso.act.ssn.l.mat[(1),]
  f.h.l <- enso.act.ssn.l.mat[(k+1),]-enso.for.ssn.l.mat[(k+1),]
  f.h.n <- enso.act.ssn.l.mat[(k+1),]-enso.for.ssn.n.mat[(k+1),]
  
  f.h.al <- enso.act.ssn.l.mat[(1),]  -enso.for.ssn.l.mat[(k+1),]
  f.h.an <- enso.act.ssn.l.mat[(1),]  -enso.for.ssn.n.mat[(k+1),]
  f.h.ln <- enso.for.ssn.l.mat[(k+1),]-enso.for.ssn.n.mat[(k+1),]
  
  rmsfe.ssn[k,] <- c(sqrt(mean(f.h.a^2)),sqrt(mean(f.h.l^2)),sqrt(mean(f.h.n^2)))
  
  f.h.1 <- as.matrix(f.h.a^2 - (f.h.l^2 - f.h.al^2))
  f.h.2 <- as.matrix(f.h.a^2 - (f.h.n^2 - f.h.an^2))
  f.h.3 <- as.matrix(f.h.l^2 - (f.h.n^2 - f.h.ln^2))
  
  model.1 <- lm(f.h.1~1)
  model.2 <- lm(f.h.2~1)
  model.3 <- lm(f.h.3~1)
  
  b.h.1 <- coef(summary(model.1))[,1]
  b.h.2 <- coef(summary(model.2))[,1]
  b.h.3 <- coef(summary(model.3))[,1]
  
  s.h.1 <- sqrt(vcovHAC(model.1))
  s.h.2 <- sqrt(vcovHAC(model.2))
  s.h.3 <- sqrt(vcovHAC(model.3))
  
  t.h.l.ssn[k,1] <- b.h.1/s.h.1
  t.h.l.ssn[k,2] <- b.h.2/s.h.2
  t.h.l.ssn[k,3] <- b.h.3/s.h.3
}
  

enso.0  <- as.matrix(enso.f[(480+1):(480+12*nit+hor)])


# h-step=ahead

pcp.mat <- matrix(,hor,6)

#pcpee.mat <- matrix(,hor,4)
trshd <- 0.45 # enso threshold


for(hs in 1:hor){

enso.ssn.l.for <- cbind(enso.act.ssn.l.mat[(hs),1:(12*nit)],enso.for.ssn.l.mat[(hs),1:(12*nit)],t(enso.for.ssn.l.prb[,(hs),1:(12*nit)]))

enso.ssn.l.for.bin <- matrix(0,nrow(enso.ssn.l.for),3)
for(i in 1:nrow(enso.ssn.l.for)){
if((enso.ssn.l.for[i,1] < -trshd) & (enso.ssn.l.for[i,2] < -trshd)){
enso.ssn.l.for.bin[i,1] <- 1
}
if((enso.ssn.l.for[i,1] >  trshd) & (enso.ssn.l.for[i,2] >  trshd)){
enso.ssn.l.for.bin[i,2] <- 1
}
if((enso.ssn.l.for[i,1] < -1)){
enso.ssn.l.for.bin[i,3] <- enso.ssn.l.for[i,3]
}else if((enso.ssn.l.for[i,1] < -trshd)){
enso.ssn.l.for.bin[i,3] <- enso.ssn.l.for[i,4]
}else if((enso.ssn.l.for[i,1] <  trshd)){
enso.ssn.l.for.bin[i,3] <- enso.ssn.l.for[i,5]
}else if((enso.ssn.l.for[i,1] <  1)){
enso.ssn.l.for.bin[i,3] <- enso.ssn.l.for[i,6]
}else{
enso.ssn.l.for.bin[i,3] <- enso.ssn.l.for[i,7]
}
}

cp.l <- as.matrix(apply(enso.ssn.l.for.bin[,1:2],2,sum))

op.l <- as.matrix(c(length(enso.ssn.l.for[((enso.ssn.l.for[,1]) < -trshd)==T,1]),
length(enso.ssn.l.for[((enso.ssn.l.for[,1]) > trshd)==T,1])))

pcp.l <- cbind(t(100*cp.l/op.l),apply(as.matrix(enso.ssn.l.for.bin[,3]),2,mean)) 



enso.ssn.n.for <- cbind(enso.act.ssn.l.mat[(hs),1:(12*nit)],enso.for.ssn.n.mat[(hs),1:(12*nit)],t(enso.for.ssn.n.prb[,(hs),1:(12*nit)]))

enso.ssn.n.for.bin <- matrix(0,nrow(enso.ssn.n.for),3)
for(i in 1:nrow(enso.ssn.n.for)){
if((enso.ssn.n.for[i,1] < -trshd) & (enso.ssn.n.for[i,2] < -trshd)){
enso.ssn.n.for.bin[i,1] <- 1
}
if((enso.ssn.n.for[i,1] >  trshd) & (enso.ssn.n.for[i,2] >  trshd)){
enso.ssn.n.for.bin[i,2] <- 1
}
if((enso.ssn.n.for[i,1] < -1)){
enso.ssn.n.for.bin[i,3] <- enso.ssn.n.for[i,3]
}else if((enso.ssn.n.for[i,1] < -trshd)){
enso.ssn.n.for.bin[i,3] <- enso.ssn.n.for[i,4]
}else if((enso.ssn.n.for[i,1] <  trshd)){
enso.ssn.n.for.bin[i,3] <- enso.ssn.n.for[i,5]
}else if((enso.ssn.n.for[i,1] <  1)){
enso.ssn.n.for.bin[i,3] <- enso.ssn.n.for[i,6]
}else{
enso.ssn.n.for.bin[i,3] <- enso.ssn.n.for[i,7]
}
}

cp.n <- as.matrix(apply(enso.ssn.n.for.bin[,1:2],2,sum))

op.n <- as.matrix(c(length(enso.ssn.n.for[((enso.ssn.n.for[,1]) < -trshd)==T,1]),
length(enso.ssn.n.for[((enso.ssn.n.for[,1]) > trshd)==T,1])))

pcp.n <- cbind(t(100*cp.n/op.n),apply(as.matrix(enso.ssn.n.for.bin[,3]),2,mean))  


pcp.mat[hs,] <- cbind(pcp.l,pcp.n)

}



